/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#pragma once

#include "Packet.h"

#include <cstdint>
#include <exception>
#include <memory>
#include <msgpack.hpp>
#include <optional>

class InputPacket;
class RpcRemoteException;

class OutputPacket : public Packet
{
public:
	msgpack::packer<msgpack::sbuffer> Message;
	OutputPacket(const char s[], std::uint32_t len, PacketType p, std::optional<std::uint32_t> id = {});
	~OutputPacket();
	static std::unique_ptr<OutputPacket> AllocateRequest(std::uint32_t messageId);
	static std::unique_ptr<OutputPacket> AllocateResponse(InputPacket request);
	static std::unique_ptr<OutputPacket> AllocateResponse(InputPacket request, std::exception e);
	static std::unique_ptr<OutputPacket> AllocateResponse(InputPacket request, RpcRemoteException e);
	static std::unique_ptr<OutputPacket> AllocateNotification();
	static std::unique_ptr<OutputPacket> AllocateErrorNotification();
	std::uint8_t* Close();
};
